/************************************************************************************************/
/*                                      Includes Section                                        */
/************************************************************************************************/
#include "FIR.h"
#include "HeartRate.h"
#include "derivative.h" 

/************************************************************************************************/
/*                                     Constants Section                                        */
/************************************************************************************************/

/************************************************************************************************/
/*                                Function Prototipes Section                                   */
/************************************************************************************************/


/************************************************************************************************/
/*                                Global Variables Section                                      */
/************************************************************************************************/
INT32 ADC_Buffer[FLT_ORDER];  
 
volatile UINT16 wADCData;
UINT8 Index = 0;
UINT32 FilterOutput = 0;
volatile UINT32 OutDiv = 350000;  //355000; 
volatile INT16 Offset =  14000;   //15000;
UINT8 gu8FilterTimeElapsed = 0;

//band pass --> 3-50 Hz
INT32 BandPassCoef_4EKG[]=
{
  0, -3, -2, 0, 2, 4, 4, 2, -3, -11, -21, -35, -50, -66, -80, -92, -98, -98, -91, -75, -51, -22, 10, 41, 67,
  84, 86, 71, 37, -17, -88, -172, -263, -352, -428, -482, -502, -481, -412, -291, -119, 100, 358, 642, 938,
  1227, 1495, 1724, 1899, 2009, 2047, 2009, 1899, 1724, 1495, 1227, 938, 642, 358, 100, -119, -291, -412,
  -481, -502, -482, -428, -352, -263, -172, -88, -17, 37, 71, 86, 84, 67, 41, 10, -22, -51, -75, -91, -98,
  -98, -92, -80, -66, -50, -35, -21, -11, -3, 2, 4, 4, 2, 0, -2, -3, 0
}; 


/************************************************************************************************/
/*                                      Functions Section                                       */
/************************************************************************************************/

UINT32 u32MAC(INT32 *SamplePtr, INT32 *BuffEdge, INT32 *CoefPtr)
{
  UINT8 FltOrder = FLT_ORDER;
	INT32 Mul = 0;
	INT32 Add = 0;
/*
     asm
     {
          move.l SamplePtr,A0
          move.l CoefPtr,A1
          move.l #0,MACSR
          move.l #0,ACC
     }
*/
	while(FltOrder--)
	{
	     Mul = (INT32)((*SamplePtr++) * (*CoefPtr++));
	     Add += Mul;
/*
	     asm
	     {
	          move.l (A0)+,D0
	          move.l (A1)+,D1
	          MAC.l D0,D1
	     }
*/
	     if(SamplePtr == BuffEdge)
	     {
	          SamplePtr -= FLT_ORDER;
	     }
	}
/*
	asm
	{
	     move.l ACC,D0
	     move.l D0,Add
	}
*/

     if(Add & (INT32)(0x80000000))
     {
          return(0);
     }
     return((UINT32)(Add));
}

/************************************************************************************************/

void filter_execution(void)
{
  gu8FilterTimeElapsed = 0;
            
  if(ADCSC1A_COCOA)
  {
    wADCData = ADCRA;
    //ADCSC1A = 0x04;                         //select channel 4
    ADCSC1A = 0x10;
    
  #ifdef FLT_TIME_PIN 
    PTFD_PTFD0 = 1;
  #endif

    ADC_Buffer[Index] = (INT32)(wADCData);
    ADC_Buffer[Index] += Offset;
		
	#ifdef FLT_ENABLE
    FilterOutput = u32MAC(&ADC_Buffer[Index], &ADC_Buffer[FLT_ORDER], &BandPassCoef_4EKG[0]);
		FilterOutput = (FilterOutput / OutDiv);
		    
	#else
    //ECO MODE 
    FilterOutput = (wADCData/16);                  
  #endif
             
    if(Index)
    {
      Index--;
    }
    else
    {
      Index = FLT_ORDER -1;
    }
  
  #ifdef DAC_ENABLE         		
    if(FilterOutput > 4095)
    {
      DACDAT0 = 0x0FFF;
    }
    else
    {
      DACDAT0 = (UINT16)(FilterOutput);
    }
  #endif
  
  #ifdef FLT_TIME_PIN   
    PTFD_PTFD0 = 0;
  #endif
  }              
}